#include <string.h>
#include "c4d_memory.h"
#include "operatingsystem.h"

void _GeFree(void **Daten)
{
	if (*Daten)
	{
		C4DOS.Ge->Free(*Daten);
	}
	*Daten=0;
}

void ClearMem(void *d, LONG size, LONG value)
{
	memset(d,value&0xFF,size);
}

void CopyMem(void *s, void *d, LONG size)
{
	memcpy(d,s,size);
}

#ifdef __MAC
	#include <size_t.h>
	#if defined(__cplusplus) && defined(_MSL_USING_NAMESPACE)
		using namespace std;
	#endif
#endif

void* operator new(size_t s)
{
	return C4DOS.Ge->Alloc(s<1?1:s,0,NULL);
}

void* operator new(size_t s,int line,const CHAR *file)
{
	return C4DOS.Ge->Alloc(s<1?1:s,line,file);
}

void* operator new[](size_t s)
{
	return C4DOS.Ge->Alloc(s<1?1:s,0,NULL);
}

void* operator new[](size_t s,int line,const CHAR *file)
{
	return C4DOS.Ge->Alloc(s<1?1:s,line,file);
}

void operator delete(void *p)
{
	if (p)
	{
		void *temp=p;
		C4DOS.Ge->Free(temp);
	}
}

void operator delete[](void *p)
{
	if (p)
	{
		void *temp=p;
		C4DOS.Ge->Free(temp);
	}
}

// for STL
void operator delete(void *p, int line,const CHAR *file)
{
  delete p;
}

void operator delete[](void *p, int line,const CHAR *file)
{
  delete[] p;
}

MemoryPool *MemoryPool::Alloc(LONG block_size)
{
	return C4DOS.Pl->Alloc(block_size);
}

MemoryPool *MemoryPool::Alloc()
{
	return C4DOS.Pl->Alloc(MEMORYPOOL_DEFAULT_BLOCKSIZE);
}

void MemoryPool::Free(MemoryPool *&pool)
{
	if (pool) C4DOS.Pl->Free(pool);
	pool=NULL;
}

void *MemoryPool::MemAlloc(LONG size, Bool clear)
{
	return C4DOS.Pl->AllocElement(this,size,clear);
}

void MemoryPool::MemFree(void *mem, LONG size)
{
	C4DOS.Pl->FreeElement(this,mem,size);
}

void *MemoryPool::MemAllocS(LONG size, Bool clear)
{
	return C4DOS.Pl->AllocElementS(this,size,clear);
}

void MemoryPool::MemFreeS(void *mem)
{
	C4DOS.Pl->FreeElementS(this,mem);
}
